global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

* colour blind friendly colours
global cblue "0 114 178"
global cred "213 94 0"
global corange "230 159 0"
global cyellow "240 228 66"
global cgreen "0 158 115"
global cblack "0 0 0"
global cgrey "60 60 60"
global cpurple "204 121 167"
global cskyblue "86 180 233"

global graphsettings graphregion(color(white)) bgcolor(white) ylabel(, grid glcolor(gs15))


// figure 4 - critical goods during COVID-19
use "$BPEAout/v2_data/v2_fig4_criticalGoodsCovid.dta", clear
tsset year

foreach v of varlist multiple630790 multipleWLD { 
	su `v' if year == 2021 , meanonly 
	local name: variable label `v'
	local call `call' text(`r(mean)' 2021 "`name'",  place(r))  
}
 

twoway 	(tsline multiple630790, lcolor("$cskyblue")) || ///
		(tsline multipleWLD, lcolor("$cgrey")), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(2018(1)2021) tscale(r(2018 2022)) ///
		title("Panel A", color(black)) ///
		ytitle("Multiple of world import value in 2018 at constant prices", size(medlarge)) xtitle("") ///
		ylabel(1(1)7, gmin gmax) 

graph save "$BPEAout/v2_graphs/vf_fig4_panelA.gph", replace
*graph export "$BPEAplots/v2/vf_fig4_panelA.pdf", replace
*graph export "$BPEAplots/v2/vf_fig4_panelA.png", replace
*graph export "$BPEAplots/v2/vf_fig4_panelA.eps", replace
local call


foreach v of varlist multiple190110 multiple270900 multiple300410 multiple850760 multiple854231 { 
	su `v' if year == 2021 , meanonly 
	local name: variable label `v'
	if "`v'" == "multiple270900" {
		local m = `r(mean)'-.02
		local call `call' text(`m' 2021 "`name'",  place(r))  
	} 
	else if "`v'" == "multiple300410" {
		local m = `r(mean)'+0.02
		local call `call' text(`m' 2021 "`name'",  place(r))  
	} 
	else if "`v'" == "multiple190110" {
		local m = `r(mean)'
		local call `call' text(`m' 2021 "`name'",  place(r))  
	} 
	else {
		local call `call' text(`r(mean)' 2021 "`name'",  place(r))  
	}
}	
	
twoway 	(tsline multiple190110, lcolor("$cblue")) || ///
		(tsline multiple270900, lcolor("$cred")) || ///
		(tsline multiple300410, lcolor("$cgreen")) || ///
		(tsline multiple850760, lcolor("$cyellow")), || ///
		(tsline multiple854231, lcolor("$cpurple")), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(2018(1)2021) tscale(r(2018 2022)) ///
		title("Panel B", color(black)) ///
		xtitle("") ///
		ylabel(0.5(0.5)2, gmin gmax)

graph save "$BPEAout/v2_graphs/vf_fig4_panelB.gph", replace
*graph export "$BPEAplots/v2/vf_fig4_panelB.pdf", replace
*graph export "$BPEAplots/v2/vf_fig4_panelB.png", replace
*graph export "$BPEAplots/v2/vf_fig4_panelB.eps", replace
local call


// combine plots 
cd "$BPEAout/v2_graphs"
local settings xsize(16) ysize(9) graphregion(color(white)) ///
				rows(1) xcommon
				
graph combine "vf_fig4_panelA.gph" "vf_fig4_panelB.gph" , `settings'

graph save "$BPEAout/v2_graphs/vf_fig4.gph", replace
graph export "$BPEAplots/vf/pdf/vf_fig4.pdf", replace
graph export "$BPEAplots/vf/png/vf_fig4.png", width(4800) height(2700) replace
graph export "$BPEAplots/vf/eps/vf_fig4.eps", replace


